## Function for converting EIA level data to EHA dams
## e.g., Hoover should be combined to a single point rather than...
## ... Hoover (AZ) and Hoover (NV) separately

convert_EIA_to_COMPLX <- function(EHA, target_plants,
                                  gen_aCF_1980_2022,
                                  gen_1980_2022_monthly_with_freq){
 
  
  EHA |>
    mutate(COMPLXID = str_replace(EHA_PtID, "\\_..*", "")) |>
    rename(EIA_ID = EIA_PtID) |> 
    unique() |>
    mutate(EIA_ID = as.integer(EIA_ID)) |> 
    filter(!is.na(EIA_ID), EIA_ID %in% target_plants[["EIA_ID"]]) |> filter(COMPLXID == "hc1017") %>% .[,1:7]
    mutate(COMPLXID = case_when(
      EIA_ID == 10186L ~ "hc1425-hc1426",
      EIA_ID == 54639L ~ "hc1355-hc1356-hc1357-hc1358-hc1359-hc1360",
      EIA_ID == 54134L ~ "hc1492-hc1493-hc1494-hc1495-hc1496-hc1497",
      EIA_ID == 57690L ~ "hc0165-hc0166",
      .default = COMPLXID
    )) |> unique() ->
    EIA_to_COMPLX_mapping

  gen_aCF_1980_2022 |>
    left_join(EIA_to_COMPLX_mapping,
              by = join_by(EIA_ID)) |>
    summarise(Jan = sum(Jan), Feb = sum(Feb), Mar = sum(Mar),
              Apr = sum(Apr), May = sum(May), Jun = sum(Jun),
              Jul = sum(Jul), Aug = sum(Aug), Sep = sum(Sep),
              Oct = sum(Oct), Nov = sum(Nov), Dec = sum(Dec),
              TotalGen_MWh = sum(TOTAL),
              nameplate_MW = sum(nameplate), cap_MWh = sum(cap_MWh),
              .by = c(COMPLXID, year)) |>
    mutate(aCF = TotalGen_MWh / cap_MWh) |>
    arrange(COMPLXID) ->
    gen_aCF_1980_2022_COMPLX
  
  gen_aCF_1980_2022_COMPLX
  
  return(gen_cap_CF_1970_2022_plus_static)
  
}